#include <iostream>
#include <algorithm>
#include <iomanip>
using namespace std;

const int kMaxN = 1e5 + 10;

int n;
int pw;
int vw[kMaxN], pf[kMaxN], vf[kMaxN], th[kMaxN];

struct Box
{
    double C1;
    double C2;

    double W;

    bool is_left;
};

Box b[kMaxN];

bool cmp(const Box& lhs, const Box& rhs)
{
    return lhs.W < rhs.W;
}

const double eps = 1e-9;

int main()
{
    ios_base::sync_with_stdio(false);

    cout << fixed << setprecision(15);

    while (true) {
        cin >> n;

        if (n == 0) {
            break;
        }

        cin >> pw;

        for (int i = 0; i < n; ++i) {
            cin >> vw[i] >> pf[i] >> vf[i] >> th[i];
        }

        double global_answer = 0.0;

        int m = 0;
        for (int i = 0; i < n; ++i) {
            if (vw[i] == 0) {
                global_answer += 1.0 * max(0, th[i]) / vf[i] * pf[i];
            } else {
                vw[m] = vw[i];
                pf[m] = pf[i];
                vf[m] = vf[i];
                th[m] = th[i];
                ++m;
            }
        }
        n = m;
        m = 0;
        for (int i = 0; i < n; ++i) {
            b[m].C1 = 1.0 * th[i] * pf[i] / vf[i];
            b[m].C2 = 1.0 * vw[i] * pf[i] / vf[i];

            b[m].W = b[i].C1 / b[i].C2;

            if (vw[i] < 0) {
                b[m].is_left = true;
            } else {
                b[m].is_left = false;
            }

            ++m;
        }

        sort(b, b + m, cmp);

        double c1_left_sum = 0.0;
        double c2_left_sum = 0.0;

        double c1_right_sum = 0.0;
        double c2_right_sum = 0.0;

        for (int i = 0; i < m; ++i) {
            if (!b[i].is_left) {
                c1_right_sum += b[i].C1;
                c2_right_sum += b[i].C2;
            }
        }

        double answer = 0.0;
        for (int i = 0; i < m; ++i) {
            answer += 1.0 * max(0, th[i]) / vf[i] * pf[i];
        }

        for (int i = 0; i < m; ++i) {
            if (!b[i].is_left) {
                c1_right_sum -= b[i].C1;
                c2_right_sum -= b[i].C2;
            }

            if (b[i].W > eps) {
                double cur_answer = b[i].W * pw;

                cur_answer += c1_left_sum - b[i].W * c2_left_sum;
                cur_answer += c1_right_sum - b[i].W * c2_right_sum;

                answer = min(answer, cur_answer);
            }


            if (b[i].is_left) {
                c1_left_sum += b[i].C1;
                c2_left_sum += b[i].C2;
            }
        }

        cout << answer + global_answer << endl;
    }


    return 0;
}
